#include <cv.h>
#include <cvaux.h>
#include <cxcore.h>
#include <highgui.h>
#include <iostream>

#include <opencv2/objdetect/objdetect.hpp>
#include <opencv2/features2d/features2d.hpp>
#include <opencv2/highgui/highgui.hpp>
#include <opencv2/calib3d/calib3d.hpp>
#include <opencv2/imgproc/imgproc_c.h>

#include "camera_kalman.h"
#include "cam.h"
#include "PointObserver.h"

#include <glut.h>

using namespace std;
using namespace cv;

//---------------------------------------------------------------------------
// Defines
//---------------------------------------------------------------------------
#define GL_WIN_SIZE_X 1280
#define GL_WIN_SIZE_Y 1024

#define DISPLAY_MODE_OVERLAY	1
#define DISPLAY_MODE_DEPTH		2
#define DISPLAY_MODE_IMAGE		3
#define DEFAULT_DISPLAY_MODE	DISPLAY_MODE_DEPTH

#define MAX_DEPTH 10000


int main(int argc, char* argv[])
{
	//load video streams
	VideoCapture img, dpt;

	if(argc < 2) 
	{
		img.open("cap_rgb.avi");
		dpt.open("cap_depth.avi");
	} else {
		img.open(argv[1]);
		dpt.open(argv[2]);
	}

	int keyframe = 50; //every keyframe do matching again

	Mat un_image, g_image, un_depth, last, draw, image, depth;

	IplImage *last_image = cvCreateImage(cvSize(640, 480), 8, 1);
	IplImage *eig_image = cvCreateImage(cvSize(640, 480), IPL_DEPTH_32F, 1);
	IplImage *tmp_image = cvCreateImage(cvSize(640, 480), IPL_DEPTH_32F, 1);

	//corner extraction
	PointObserver po(50);

	//camera related
	Camera cam;
	cam.cameraMatrix = (CvMat*)cvLoad("Intrinsics_IR.xml");
	cam.distortion = (CvMat*)cvLoad("Distortion_IR.xml");
	cam.transVect = cvCreateMat(3, 1, CV_32F);
	cvZero(cam.transVect);
	cam.rotMatrix = cvCreateMat(1, 3, CV_32F);
	cvZero(cam.rotMatrix);

	//load camera matrices
	po.loadMatrix("Intrinsics_RGB.xml", po.cam_A);
	po.loadMatrix("Distortion_RGB.xml", po.cam_D);

	po.loadMatrix("Intrinsics_IR.xml", po.dep_A);
	po.loadMatrix("Distortion_IR.xml", po.dep_D);

	//skip first frame
	img >> image;
	dpt >> depth;

	//loop
	while(1) 
	{

		if(!img.isOpened() || !dpt.isOpened()) 
		{
			printf("Could not grab a frame\n\7");
			return 0;
		}
		img >> image;
		dpt >> depth;
		//undistort images
		undistort(image, un_image, po.cam_A, po.cam_D, po.cam_A);
		undistort(depth, un_depth, po.dep_A, po.dep_D, po.dep_A);
		
		cvtColor(un_image, g_image, CV_RGB2GRAY);

		//track points
		//po.trackPoints(g_image);

		po.trackPoints(g_image, un_depth, keyframe);

		cout << po.cam_T.at<double>(0, 0) << " " << po.cam_T.at<double>(1, 0) << " " << po.cam_T.at<double>(2, 0) << "\n"; 
		cout << po.cam_R.at<double>(0, 0) << " " << po.cam_R.at<double>(1, 0) << " " << po.cam_R.at<double>(2, 0) << "\n"; 

		int cnt = 0;
		if(!po.keys2.empty()) 
		{
			//draw
			for(int a = 0; a < po.keys.size(); a++) 
			{
				if(po.tracker.state[a] == 1) {
					circle(un_image, po.keys[a].pt, 1, CV_RGB(255, 0, 0), 3, 8, 0);
					line(un_image, po.keys[a].pt, po.keys2[a].pt, CV_RGB(0, 255, 0), 1, 8, 0);

					cnt ++;
				}
			}
		}
		printf("Features: %d, Matched: %d\n", po.keys.size(), cnt);

		image.copyTo(last);
		if(!draw.empty())
			imshow("win", draw);
		else {
			imshow("win", un_image);
			imshow("win2", un_depth);
		}
		waitKey(0);
	}

	return 0;
}